unit Utility;

interface

uses
Forms, Graphics, WinTypes, SysUtils, WinProcs, MMSystem, StdCtrls, Classes,
  ExtCtrls, Messages, Controls;

function AppPath: String;
procedure CreateBitmapMasks( bmSource, bm1, bm2: Graphics.TBitmap; clTrans: TColor );
function Distance( const pt1, pt2: TPoint ) : single;
function EqualPt( pt1, pt2: TPoint ): boolean;
function GetDeviceColors( h: HDC ): longint;
function GetToken( var sString: String; const sDelim: String ): String;
procedure PlayWave( const sFile: String; bOption: boolean );
procedure replace( var s: string; cFrom, cTo: char );
function SecondsApart( const t1, t2: TDateTime ): integer;
procedure SendClick( hWnd: THandle );
function stripExtension( const sFileName: string ): string;
function stripPath( const sFileName: string ): string;
function TagOf( ctl: TWinControl; const i: integer ): TComponent;
function TagOfClass( ctl: TWinControl; const i: integer; cls: string ): TComponent;
function RandomizeValue( const x, xRandomness: extended ): extended;
function HiNibble( n: byte ): byte;
function LoNibble( n: byte ): byte;

implementation

(*********************************************
Return the application path minus file name.
*********************************************)
function AppPath: String;
var
  sTemp, sPath: String;
  nPos: integer;
begin
  sTemp := Application.ExeName;
  sPath := '';
  nPos := Pos( '\', sTemp );
  while ( nPos > 0 ) do
     begin
        sPath := sPath + GetToken( sTemp, '\' ) + '\';
        nPos := Pos( '\', sTemp );
     end;
  AppPath := sPath;
end;

function EqualPt( pt1, pt2: TPoint ): boolean;
begin
  Result := (pt1.X = pt2.X) and (pt1.Y = pt2.Y); 
end;

procedure CreateBitmapMasks( bmSource, bm1, bm2: Graphics.TBitmap; clTrans: TColor );
var
  x, y: integer;
begin
  bm1.Assign( bmSource );
  bm2.Assign( bmSource );
  for x := 0 to bmSource.Width - 1 do
     for y := 0 to bmSource.Height - 1 do
        begin
           if bmSource.Canvas.Pixels[x, y] = clTrans then
              begin
                 bm1.Canvas.Pixels[x, y] := clWhite;
                 bm2.Canvas.Pixels[x, y] := clBlack;
              end
           else
              begin
                 bm1.Canvas.Pixels[x, y] := clBlack;
              end;
        end;
end;

(*********************************************
Standard distance formula.
*********************************************)
function Distance( const pt1, pt2: TPoint ) : single;
begin
  Result := Sqrt( Sqr( pt2.X - pt1.X ) + Sqr( pt2.Y - pt1.Y ) )
end;

(*********************************************
Find out how many colors the screen supports.
*********************************************)
function GetDeviceColors( h: HDC ): longint;
var
  n1, n2: longint;
begin
  n1 := GetDeviceCaps( h, PLANES );
  n2 := GetDeviceCaps( h, BITSPIXEL );
  if n2 = 32 then
    Result := High( integer )
  else
    Result := longint( 1 ) shl ( n1 * n2 );
end;

(*********************************************
Strips a token from a string.
*********************************************)
function GetToken( var sString: String; const sDelim: String ): String;
var
  nPos: integer;
begin
  nPos := Pos( sDelim, sString );
  if nPos > 0 then
     begin
        GetToken := Copy( sString, 1, nPos - 1 );
        sString := Copy( sString, nPos + 1, Length( sString ) - nPos );
     end
  else
     begin
        GetToken := sString;
        sString := '';
     end;
end;

(*********************************************
Play a WAV file.
*********************************************)
procedure PlayWave( const sFile: String; bOption: boolean );
var
  nFlags: word;
  sFile_: string;
begin
  if bOption then
     begin
        sFile_ := sFile;
        if Pos( '\', sFile ) = 0 then
           sFile_ := AppPath + sFile;
        nFlags := SND_ASYNC + SND_NODEFAULT;
try
        sndPlaySound( PChar( sFile_ ), nFlags );
except;
end;
     end;
end;

(*********************************************
Randomize a float by a specified factor.
Randomness = 0 (No Randomness) to 1 (Full Randomness)
*********************************************)
function RandomizeValue( const x, xRandomness: extended ): extended;
var
  xMult, xTerm1, xTerm2: extended;
begin
  xMult := Random + 0.5;
  xTerm1 := x * xMult;
  xTerm1 := xTerm1 * xRandomness;
  xTerm2 := x * ( 1.0 - xRandomness );
  Result := xTerm1 + xTerm2;
end;

function SecondsApart( const t1, t2: TDateTime ): integer;
var
  nDummy: word;
  nSec1, nSec2: word;
  nMin1, nMin2: word;
begin
  DecodeTime( t1, nDummy, nMin1, nSec1, nDummy );
  DecodeTime( t2, nDummy, nMin2, nSec2, nDummy );
  Result := Abs( ( ( nMin1 - nMin2 ) * 60 ) + ( nSec1 - nSec2 ) );
end;

(*********************************************
Send a click message
*********************************************)
procedure SendClick( hWnd: THandle );
begin
  PostMessage( hWnd, wm_LButtonDown, 0, 0 );
  PostMessage( hWnd, wm_LButtonUp, 0, 0 );
end;

(*********************************************
Return the control with the specified tag.
*********************************************)
function TagOf( ctl: TWinControl; const i: integer ): TComponent;
var
  j: integer;
begin
  Result := nil;
  for j := 0 to ctl.ControlCount - 1 do
     if ctl.Controls[j].Tag = i then
        begin
           Result := ctl.Controls[j];
           Break;
        end;
end;

function TagOfClass( ctl: TWinControl; const i: integer; cls: string ): TComponent;
var
  j: integer;
begin
  Result := nil;
  for j := 0 to ctl.ControlCount - 1 do
     if ctl.Controls[j].Tag = i then
        if ctl.Controls[j].ClassName = cls then
           begin
              Result := ctl.Controls[j];
              Break;
           end;
end;

function HiNibble( n: byte ): byte;
begin
  Result := n shr 4;
end;

function LoNibble( n: byte ): byte;
begin
  Result := n and ( 1 + 2 + 4 + 8 );
end;

function stripPath( const sFileName: string ): string;
var
  s: string;
  nPos: integer;
begin
  s := sFileName;
  nPos := Pos( '\', s );
  while nPos > 0 do
  begin
    s := Copy( s, nPos + 1, Length( s ) );
    nPos := Pos( '\', s );
  end;
  Result := s;
end;

function stripExtension( const sFileName: string ): string;
var
  nPos: integer;
begin
  nPos := Pos( '.', sFileName );
  if ( nPos = 0 ) then
    Result := sFileName
  else
    Result := Copy( sFileName, 1, nPos - 1 );
end;

procedure replace( var s: string; cFrom, cTo: char );
var
  i: integer;
begin
  for i := 1 to Length( s ) do
  begin
    if ( s[i] = cFrom ) then
      s[i] := cTo;
  end;
end;

end.
